#! /bin/sh

SERVER_ROOT="/opt/TrendMicro/Pixiebob/Server/"
SERVER_DATA_ROOT="${SERVER_ROOT}init/data/"
SERVER_CONF_ROOT="${SERVER_ROOT}init/config/"
SERVER_PATCH_ROOT="${SERVER_ROOT}init/patch/"
POST_INSTALL_LOG="${SERVER_ROOT}logs/post_install_server.log"
MIGRATE_FLAG="${SERVER_ROOT}init/migrate.flag"
OPENVA_UPGRADE_FLAG="${SERVER_ROOT}init/from_openva_upgrade.flag"
SSL_CERT_ROOT="/etc/nginx/ssl/"

############################################################
##               Generate Certificate                     ##
############################################################
create_certificate() {
    mkdir -p ${SSL_CERT_ROOT}

    if [ ! -f ${MIGRATE_FLAG} ]; then
        echo "[`date`] Create certificate" >> ${POST_INSTALL_LOG} 2>&1    
        # Portal certificate
        # Older browser versions does not support 4096 byte RSA key
        openssl req -x509 -subj "/CN=DDD_Management" -nodes -sha512 -days 3650 -newkey rsa:2048 -keyout ${SSL_CERT_ROOT}uc_mgmt.key -out  ${SSL_CERT_ROOT}uc_mgmt.crt  >> ${POST_INSTALL_LOG} 2>&1
        chmod 600 ${SSL_CERT_ROOT}uc_mgmt.crt
        chmod 600 ${SSL_CERT_ROOT}uc_mgmt.key     

        # dhparam
        openssl dhparam 2048 > ${SSL_CERT_ROOT}dhparam.pem
        chmod 600 ${SSL_CERT_ROOT}dhparam.pem
    else
        echo "[`date`] Migrate case, skip certificate creation..." >> ${POST_INSTALL_LOG} 2>&1
    fi

}

############################################################
##               Activate Service                         ##
############################################################
activate_system_services() {
    if [ ! -f ${MIGRATE_FLAG} ]; then
        echo "[`date`] Activate system services..." >> ${POST_INSTALL_LOG} 2>&1
        # Nginx
        /usr/bin/cp -f ${SERVER_CONF_ROOT}systemd/nginx.service /usr/lib/systemd/system/
        systemctl enable nginx.service  >> ${POST_INSTALL_LOG} 2>&1
        # Remove nginx default config
        rm -f /etc/nginx/conf.d/default.conf 

        # Postgresql
        /usr/bin/cp -f ${SERVER_CONF_ROOT}systemd/postgresql-9.6.service /usr/lib/systemd/system/              
    else
        echo "[`date`] Migrate case, re-activate system services..."  >> ${POST_INSTALL_LOG} 2>&1
        /usr/bin/cp -f ${SERVER_CONF_ROOT}systemd/postgresql-9.6.service /usr/lib/systemd/system/

        /usr/bin/cp -f ${SERVER_CONF_ROOT}systemd/nginx.service /usr/lib/systemd/system/

        systemctl daemon-reload  >> ${POST_INSTALL_LOG} 2>&1 
    fi
}

# Main logic
if test -e "${SERVER_ROOT}api/resource/VAReport"; then rm -rf "${SERVER_ROOT}api/resource/VAReport"; fi
tar zxf "${SERVER_ROOT}api/resource/vareport.tar.gz" -C "${SERVER_ROOT}api/resource"
chown -R root:root "${SERVER_ROOT}api/resource/VAReport/"
chmod -R 644 "${SERVER_ROOT}api/resource/VAReport/"

mkdir -p "${SERVER_ROOT}logs/"
create_certificate
activate_system_services

# Extract ckp packages
tar zxf ${SERVER_ROOT}api/third_party_int/ckp/ckp.tar.gz -C ${SERVER_ROOT}api/third_party_int/ckp/
rm -f ${SERVER_ROOT}api/third_party_int/ckp/ckp.tar.gz
chmod 755 ${SERVER_ROOT}api/third_party_int/ckp/bin/opsec_pull_cert
chmod 755 ${SERVER_ROOT}api/third_party_int/ckp/bin/sam_client

if [ "$(stat -c %d:%i /)" == "$(stat -c %d:%i /proc/1/root/.)" ]; then
    echo "[`date`] Installed manually, launch data initialization script." >> ${POST_INSTALL_LOG} 2>&1
    systemctl start nginx.service
    sh ${SERVER_ROOT}init/scripts/init_pixiebob.sh
elif [ -f ${OPENVA_UPGRADE_FLAG} ]; then
    echo "[`date`] Upgrade by openva, do nothing. Migration will be done after system reboot" >> ${POST_INSTALL_LOG} 2>&1
else
    echo "[`date`] Installed from kickstart, skip launching data initialization script." >> ${POST_INSTALL_LOG} 2>&1
fi
